//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Threading;
using System.Net;
using System.Net.Sockets;

namespace ProfilingSamples
{
	public class TcpMain 
	{
		private string server;
		private int port;
		TcpMain(string server, int port)
		{
			this.server = server;
			this.port = port;
		}
		void TestThread()
		{
			Socket s = null;
			try
			{
				IPHostEntry host = Dns.GetHostByName(server);
				s = new Socket(host.AddressList[0].AddressFamily, SocketType.Stream, ProtocolType.Tcp);
				IPEndPoint remoteEP = new IPEndPoint(host.AddressList[0], port);
				s.Connect(remoteEP);
				Console.WriteLine("Poczono z serwerem {0}", server);
				byte[] writeBuffer = new byte[16384];
				byte[] readBuffer = new byte[16384];
				int nTransmitted;
				int nReceived;
				int nTotalReceived;

				while(true)
				{
					nTransmitted = s.Send(writeBuffer, 0, writeBuffer.Length, SocketFlags.None);
					nReceived = 0;
					nTotalReceived = 0;
					while(nTotalReceived < nTransmitted)
					{
						nReceived = s.Receive(readBuffer, nReceived, nTransmitted - nTotalReceived, SocketFlags.None);
						nTotalReceived += nReceived;
					}
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
			finally
			{
				if(s != null)
					s.Close();
			}
		}
		static void Main(string [] args)
		{
			// Echo na porcie 7.
			TcpMain m = new TcpMain("JILAD", 7);
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}